function [A,B] = MarchingQuads(XY,QUAD,V,isovalue,isocap)
narginchk(4,5)
if nargin==4, isocap = 0; end

if size(QUAD,2)~=4
    error('Quadrangle connectivity must have size [N x 4].')
end
if size(XY,2)~=2
    error('Nodal coordinates must have size [M x 2].')
end
if numel(V)~=size(XY,1)
    error('The number of values and coordinates must match.')
end
if ~isscalar(isovalue)
    error('The isovalue must be a scalar.')
end

if (isocap < 0)
    flag = (V < isovalue);
else
    flag = (V > isovalue);
end

% Calculate the isocaps if requested
if (isocap ~= 0)
    BOUND = GetBoundary(QUAD);
    BoundIndex = 1 + flag(BOUND(:,1)) * 1 + flag(BOUND(:,2)) * 2;
    SegmentsPerBoundIndex = [0 1 1 1];
    Nbound_segments = sum(SegmentsPerBoundIndex(BoundIndex));
    Acap = nan(Nbound_segments,2);
    Bcap = nan(Nbound_segments,2);
    n = 0;
    for i=1:length(BoundIndex)
        switch BoundIndex(i)
        % case 1 is all-outside
            case 2
                n = n + 1;
                Acap(n,:) = VertexInterp(isovalue,XY(BOUND(i,1),:),XY(BOUND(i,2),:),V(BOUND(i,1)),V(BOUND(i,2)));
                Bcap(n,:) = XY(BOUND(i,1),:);
            case 3
                n = n + 1;
                Acap(n,:) = VertexInterp(isovalue,XY(BOUND(i,1),:),XY(BOUND(i,2),:),V(BOUND(i,1)),V(BOUND(i,2)));
                Bcap(n,:) = XY(BOUND(i,2),:);
            case 4
                n = n + 1;
                Acap(n,:) = XY(BOUND(i,1),:);
                Bcap(n,:) = XY(BOUND(i,2),:);
        end
    end
%     Acap = XY(BOUND(:,1),:);
%     Bcap = XY(BOUND(:,2),:);
else
    Acap = [];
    Bcap = [];
end

% Get going with the marching triangles in the interior of the domain
Nq = size(QUAD,1);
%QuadIndex = 1 + sum( flag(QUAD) .* repmat([1 2 4 8],Nq,1) , 2);
QuadIndex = 1 + flag(QUAD(:,1)) * 1 + flag(QUAD(:,2)) * 2 + flag(QUAD(:,3)) * 4 + flag(QUAD(:,4)) * 8;
SegmentsPerQuadIndex = [0 1 1 1 1 2 1 1 1 1 2 1 1 1 1 0]';
Nsegments = sum(SegmentsPerQuadIndex(QuadIndex));

A = nan(Nsegments,2);
B = nan(Nsegments,2);
n = 0;
for i=1:Nq
    switch QuadIndex(i)
        % case {1,8} is all-inside or all-outside
        case {2,15}
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(QUAD(i,1),:),XY(QUAD(i,2),:),V(QUAD(i,1)),V(QUAD(i,2)));
            B(n,:) = VertexInterp(isovalue,XY(QUAD(i,1),:),XY(QUAD(i,4),:),V(QUAD(i,1)),V(QUAD(i,4)));
        case {3,14}
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(QUAD(i,2),:),XY(QUAD(i,1),:),V(QUAD(i,2)),V(QUAD(i,1)));
            B(n,:) = VertexInterp(isovalue,XY(QUAD(i,2),:),XY(QUAD(i,3),:),V(QUAD(i,2)),V(QUAD(i,3)));
        case {4,13}
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(QUAD(i,1),:),XY(QUAD(i,4),:),V(QUAD(i,1)),V(QUAD(i,4)));
            B(n,:) = VertexInterp(isovalue,XY(QUAD(i,2),:),XY(QUAD(i,3),:),V(QUAD(i,2)),V(QUAD(i,3)));
        case {5,12}
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(QUAD(i,3),:),XY(QUAD(i,2),:),V(QUAD(i,3)),V(QUAD(i,2)));
            B(n,:) = VertexInterp(isovalue,XY(QUAD(i,3),:),XY(QUAD(i,4),:),V(QUAD(i,3)),V(QUAD(i,4)));
        case 6
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(QUAD(i,1),:),XY(QUAD(i,2),:),V(QUAD(i,1)),V(QUAD(i,2)));
            B(n,:) = VertexInterp(isovalue,XY(QUAD(i,3),:),XY(QUAD(i,2),:),V(QUAD(i,3)),V(QUAD(i,2)));
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(QUAD(i,1),:),XY(QUAD(i,4),:),V(QUAD(i,1)),V(QUAD(i,4)));
            B(n,:) = VertexInterp(isovalue,XY(QUAD(i,3),:),XY(QUAD(i,4),:),V(QUAD(i,3)),V(QUAD(i,4)));
        case 11
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(QUAD(i,2),:),XY(QUAD(i,1),:),V(QUAD(i,2)),V(QUAD(i,1)));
            B(n,:) = VertexInterp(isovalue,XY(QUAD(i,4),:),XY(QUAD(i,1),:),V(QUAD(i,4)),V(QUAD(i,1)));
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(QUAD(i,2),:),XY(QUAD(i,3),:),V(QUAD(i,2)),V(QUAD(i,3)));
            B(n,:) = VertexInterp(isovalue,XY(QUAD(i,4),:),XY(QUAD(i,3),:),V(QUAD(i,4)),V(QUAD(i,3)));
        case {7,10}
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(QUAD(i,3),:),XY(QUAD(i,4),:),V(QUAD(i,3)),V(QUAD(i,4)));
            B(n,:) = VertexInterp(isovalue,XY(QUAD(i,2),:),XY(QUAD(i,1),:),V(QUAD(i,2)),V(QUAD(i,1)));
        case {8,9}
            n = n + 1;
            A(n,:) = VertexInterp(isovalue,XY(QUAD(i,1),:),XY(QUAD(i,4),:),V(QUAD(i,1)),V(QUAD(i,4)));
            B(n,:) = VertexInterp(isovalue,XY(QUAD(i,3),:),XY(QUAD(i,4),:),V(QUAD(i,3)),V(QUAD(i,4)));
    end
end
A = [A; Acap];
B = [B; Bcap];
return

function [BOUND] = GetBoundary(QUAD)
EDGE = [QUAD(:,1) QUAD(:,2);
        QUAD(:,2) QUAD(:,3);
        QUAD(:,3) QUAD(:,4);
        QUAD(:,4) QUAD(:,1)];
EDGE = sort(EDGE,2);
[~,ia,ic] = unique(EDGE,'rows');
count = accumarray(ic,1,[length(ia) 1]);
ind = find(count==1);
BOUND = EDGE(ia(ind),:);
return

function P = VertexInterp(cutoff,P1,P2,V1,V2)
[P,ind] = sortrows([P1; P2]);
if isequal(ind,[1; 2])
    V = [V1; V2];
else
    V = [V2; V1];
end

if (abs(V(2)-V(1)) > 1e-12)
  P = P(1,:) + diff(P) * (cutoff - V(1)) / diff(V);
else
  P = P(1,:);
end
return